# AutoMatch Pro Chrome Extension v1.0

## 🎯 Overview
AutoMatch Pro is a professional Chrome extension for AmazingTalker teachers that automates student matching processes. Developed by **Cyrus Studio**.

## ✨ Features
- ✅ Automatic student match detection with modern CSP-compliant injection
- ✅ Smart credit management system with real-time monitoring
- ✅ Secure JWT authentication with 90-day sessions
- ✅ Auto-update bot scripts with version management
- ✅ Offline queue for failed submissions with intelligent retry
- ✅ Real-time activity logs with export functionality
- ✅ System notifications for important events
- ✅ Modern, streamlined user interface

## 🆕 What's New in v1.0
- **Security**: Fixed Content Security Policy issues with modern script injection
- **UI/UX**: Completely redesigned popup interface for better usability
- **Logging**: Added comprehensive activity logging with export functionality
- **Notifications**: Added system notifications for important events
- **Performance**: Improved background processing and error handling

## 📦 Installation

### Prerequisites
- Google Chrome (version 88 or higher)
- AutoMatch Pro account from [Cyrus Studio](https://hiteachers.net/automatch/my-account/)

### Installation Steps

1. **Download the extension**
   - Download the `automatch-extension.zip` file
   - Extract to a folder on your computer

2. **Enable Developer Mode in Chrome**
   - Open Chrome and navigate to `chrome://extensions/`
   - Toggle "Developer mode" switch (top right corner)

3. **Load the extension**
   - Click "Load unpacked"
   - Select the extracted `automatch-extension` folder
   - The extension icon will appear in your toolbar

4. **Login and activate**
   - Click the AutoMatch Pro icon in toolbar
   - Enter your credentials from [My Account](https://hiteachers.net/automatch/my-account/)
   - Navigate to AmazingTalker.com
   - The bot will automatically activate

## 🔧 How It Works

The extension automatically:
- Detects when you're on AmazingTalker pages
- Injects the latest bot script securely using modern Chrome APIs
- Monitors for student matching opportunities
- Submits successful matches and manages credits
- Queues failed submissions for automatic retry
- Logs all activity for transparency and debugging

## 💳 Credits System

- Each successful match consumes 1 credit
- Credits are only deducted after confirmed success
- Purchase more credits at [My Account](https://hiteachers.net/automatch/my-account/)
- Low credit warnings at 10 remaining credits
- System notifications when credits are running low

## 📊 Activity Monitoring

The new popup interface provides:
- **Real-time credit balance** with instant updates
- **Script version information** to ensure you're using the latest features
- **Queue status** showing pending submissions
- **Activity logs** with timestamped events and export functionality
- **Quick actions** for refreshing data and opening AmazingTalker

## 🔒 Security & Privacy

- JWT tokens with 90-day automatic expiration
- All data stored locally using Chrome's secure storage API
- HTTPS-only communication with encrypted endpoints
- No sensitive data exposed in logs or console
- Modern Content Security Policy compliance

## 🆘 Troubleshooting

### Extension not working?
1. Ensure you're logged in (click extension icon to check)
2. Verify you're on `*.amazingtalker.*` domain
3. Check if you have credits remaining
4. Look at the activity logs in the popup for error messages
5. Try refreshing the page

### Script not injecting?
1. Check the activity logs for injection status
2. Ensure extension has proper permissions
3. Try the "Refresh" button in the popup
4. Disable other extensions that might conflict

### Credits not updating?
1. Click the "Refresh" button in popup
2. Check your internet connection
3. Re-login if necessary
4. Check activity logs for API errors

## 🔄 Updates & Maintenance

- The extension automatically checks for script updates every hour
- System notifications inform you of successful updates
- Activity logs track all update processes
- No manual intervention required for updates

## 📞 Support

- **Account Management**: [My Account Dashboard](https://hiteachers.net/automatch/my-account/)
- **Documentation**: [https://hiteachers.net/automatch/docs](https://hiteachers.net/automatch/docs)
- **Direct Support**: [Telegram @cyrus1992](https://t.me/cyrus1992)

### Getting Help
1. Check the activity logs in the popup first
2. Use the "Export Logs" button to copy technical details
3. Contact support with your log export for faster resolution

## 🔧 Technical Details

- **Architecture**: Modern Manifest V3 with service workers
- **Script Injection**: Uses `chrome.scripting.executeScript` with `world: 'MAIN'`
- **Storage**: Chrome's local storage API for security and performance
- **Communication**: Message passing between content scripts and background
- **Retry Logic**: Intelligent queue management for network failures

## 📜 License

© 2025 Cyrus Studio. All rights reserved.

---

**Developed with ❤️ by [Cyrus Studio](https://hiteachers.net/automatch/my-account/)**